////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define _WIN32_DCOM

#include <ObjBase.H>
#include <CommCtrl.H>
#include <ShlOBJ.H>
#include <TChar.H>
#include <StdIO.H>
#include <StdLib.H>
#include <IO.h>
#include <SqlExt.H>
#include <ShlOBJ.H>
#include <Process.H>        // For C library-safe _beginthreadex,_endthreadex

#include "SQL/Vdi.H"        // Interface declaration
#include "SQL/VdiError.H"   // Error constants

#include "SQL/VdiGuid.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include "SQL.H"
#include "SqlExt.H"
#include "ODBCss.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NSWFL.H"
#include "Headers/NASCCL.H"
#include "Headers/NDBS.H"

#include "Resources/Resource.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/Definitions.H"

#include "Headers/Service.h"
#include "Headers/Security.H"
#include "Headers/Schedule.H"
#include "Headers/Registry.H"
#include "Headers/JobLogDB.H"
#include "Headers/SQLBackup.H"

#include "Headers/TrayIcon.H"

#include "Headers/SQL.H"
#include "Headers/Functions.H"
#include "Headers/Interval.H"
#include "Headers/ScheduleDB.H"
#include "Headers/RestoreName.H"
#include "Headers/Initilize.H"

#include "Headers/TrayHandler.H"

#include "Dialogs/ViewLog.H"
#include "Dialogs/JobManager.H"
#include "Dialogs/ManBackup.H"
#include "Dialogs/ManRestore.H"
#include "Dialogs/Schedule.H"
#include "Dialogs/AddSchedule.H"
#include "Dialogs/AddBackupOptions.H"
#include "Dialogs/AddSQLOptions.H"
#include "Dialogs/EditSchedule.H"
#include "Dialogs/EditBackupOptions.H"
#include "Dialogs/EditSQLOptions.H"
#include "Dialogs/ViewSchedule.H"
#include "Dialogs/SelectDB.H"
#include "Dialogs/SQLPassword.H"
#include "Dialogs/RestoreMove.H"
#include "Dialogs/w9xOptions.H"
#include "Dialogs/wNTOptions.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CheckParameter(char *CmdLine)
{
    if( strcmp(LCase(CmdLine), "/nonservice") == 0)
	{
        xMainEntry();
        return true;
    }

    MessageBox(NULL, "Not a valid command.", TitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);

    return false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR CmdLine, int CmdShow)
{
	int Length		   = 0;
	short Result	   = 0;
	LONG LastError     = 0;
    HANDLE MutexHandle = NULL;

	MainInstance = hInstance;

    //-------------------------------------------------------------------------------

    if( IsWinNT() == TRUE)
    {
    	SECURITY_DESCRIPTOR SD;
    	SECURITY_ATTRIBUTES SA;

    	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
    		return FALSE;

    	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
    		return FALSE;

    	SA.nLength				= sizeof(SA);
    	SA.lpSecurityDescriptor = &SD;
    	SA.bInheritHandle		= FALSE;
        MutexHandle = CreateMutex(&SA, FALSE, TitleCaption);
    }
    else MutexHandle = CreateMutex(NULL, FALSE, TitleCaption);

	LastError = GetLastError();
	if(MutexHandle != 0)
	{
		if(LastError == ERROR_ALREADY_EXISTS)
        {
			MessageBox(NULL, "Application already running.", TitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
			return 0;
		}
	}

    //-------------------------------------------------------------------------------

	Length = strlen(CmdLine);
	if(Length > 0)
	{
        CheckParameter(CmdLine);

    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

		return 0;
	}

    //-------------------------------------------------------------------------------

    if( IsWinNT() == FALSE)
    {
        xMainEntry();

    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return 0;
    }

    //-------------------------------------------------------------------------------

	Result = xServiceEntry(CmdLine);

	if(Result == _Success_)
    {
    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Success_);
    }

	if(Result == _Error_)
    {
        xMainEntry();

    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Error_);
    }

    //-------------------------------------------------------------------------------

    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int xMainEntry(void)
{
    if(InitilizeAll() == FALSE)
        return 0;

    LoadTrayIcon(TrayIcon, TitleCaption);

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

